#include <kilolib.h>
#define DEBUG
#include <debug.h>

message_t message;
// Flag to keep track of message transmission.
int message_sent = 0;
// Flag to keep track of new messages.
int new_message = 0;
int distance = 0;
int Mess0 = 0;
int Mess1 = 0;
static int TestLED=0;

void setup()
{

    // Initialize message:
    // The type is always NORMAL.
    message.type = NORMAL;
    // Some dummy data as an example.
    message.data[0] = 0;
    // It's important that the CRC is computed after the data has been set;
    // otherwise it would be wrong and the message would be dropped by the
    // receiver.
    message.crc = message_crc(&message);





}



void loop() {

	/////////////////////////////////////////////////////////////////////////////////////
	//user program code goes here.  this code needs to exit in a resonable amount of time
	//so the special message controller can also run
	/////////////////////////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////////////////////////
	//
	//  In the example below, the robots are moving if they can't see each other.
	//  Otherwise,they are displaying they distance to each other with the rgb led.
	//
	////////////////////////////////////////////////////////////////////////////////////

  // Print the ambient light on the debug port

	printf("ambient: %3d\n",get_ambientlight());



	//check for message

	delay(10);//wait 10 ms

    // Blink the LED yellow whenever a message is received.
    if (new_message == 1)
    {
        // Reset the flag so the LED is only blinked once per message.
        new_message = 0;
		set_motors(0,0);

		if(distance == 33)
			set_color(RGB(3,3,3));//turn RGB LED White

		else if(distance < 40)
	        set_color(RGB(3,0,0));//turn RGB LED Red

		else if(distance < 50)
		  set_color(RGB(3,3,0));//turn RGB LED Orange

		else if(distance < 60)
		  set_color(RGB(0,3,0));//turn RGB LED Green

		else if(distance < 70)
		  set_color(RGB(0,3,1));//turn RGB LED Turquoise

		else if(distance < 80)
			set_color(RGB(0,0,3));//turn RGB LED Blue

		else if(distance < 90)
			set_color(RGB(3,0,3));//turn RGB LED Violet

		printf("received:\n");
		printf("id mes dis %u, %u, %u\n\r",Mess0,Mess1,distance);


		delay(500);//wait 500 ms

		set_color(RGB(0,0,0));//turn RGB LED off


    }
	else
	{
	    if(++TestLED > 39)
	    {
	        TestLED = 3;
	        set_motors(0,0);
	    }
	    else if(TestLED <= 15)
        {
	        set_color(RGB(TestLED>>2,0,0));
	        if(TestLED == 4)
	        {
                // Spinup the motors to overcome friction.
                spinup_motors();
	        }
            set_motors(kilo_straight_left, kilo_straight_right);
	   }
	   else if(TestLED <= 27)
	   {
	        set_color(RGB(0, ((TestLED>>2)-3),0));
	        if(TestLED == 16)
	        {
                // Spinup the motors to overcome friction.
                spinup_motors();
	        }
            set_motors(kilo_turn_left, 0);
        }
	    else if(TestLED <= 39)
        {
            set_color(RGB(0,0,((TestLED>>2)-6)));
	        if(TestLED == 28)
            {
                // Spinup the motors to overcome friction.
                spinup_motors();
            }
            set_motors(0, kilo_turn_right);
        }
        delay(500);
	   }






}


message_t *message_tx()
{
    return &message;
}

void message_tx_success()
{
    // Set the flag on message transmission.
    message_sent = 1;
}

void message_rx(message_t *message, distance_measurement_t *distance_measurement)
{
    // Set the flag on message reception.
    new_message = 1;
    distance = estimate_distance(distance_measurement);
    Mess0 = message->data[0];
    Mess1 = message->data[1];
}

int main() {
    // initialize hardware
    kilo_init();
    debug_init();
    // Register the message_tx callback function.
    kilo_message_tx = message_tx;
    // Register the message_tx_success callback function.
    kilo_message_tx_success = message_tx_success;
    // Register the message_rx callback function.
    kilo_message_rx = message_rx;
    // start program
    kilo_start(setup, loop);

    return 0;
}

